/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CUnicodeString.h,v 1.6 1999/10/11 07:06:04 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CUnicodeString_h	// [
#define Included_CUnicodeString_h

#include "pgpClassesConfig.h"

#include "CArray.h"
#include "CErrorState.h"

_PGP_BEGIN

// Types

class CString;


// Class CUnicodeString

class CUnicodeString : public CErrorState
{

public:
	enum {kDefaultUStringSize = 128};

	CUnicodeString();
	CUnicodeString(const CUnicodeString& custr);
	explicit CUnicodeString(const UNICODE_STRING& ustr);
	explicit CUnicodeString(const WCHAR *wstr);
	explicit CUnicodeString(const char *str);
	explicit CUnicodeString(char c);
	~CUnicodeString() { }

	CUnicodeString&	operator=(const CUnicodeString& custr);
	CUnicodeString&	operator=(const UNICODE_STRING& ustr);
	CUnicodeString&	operator=(const WCHAR *wstr);
	CUnicodeString&	operator=(const char *str);
	CUnicodeString&	operator=(char c);

	CUnicodeString&	operator+=(const UNICODE_STRING& ustr);
	CUnicodeString&	operator+=(const WCHAR *wstr);
	CUnicodeString&	operator+=(const char *str);
	CUnicodeString&	operator+=(char c);

	PGPBoolean	operator==(const UNICODE_STRING& ustr) const
	{
		return Compare(ustr);
	}

	PGPBoolean	operator==(const WCHAR *wstr) const
	{
		return Compare(wstr);
	}

	PGPBoolean	operator!=(const UNICODE_STRING& ustr) const
	{
		return !Compare(ustr);
	}

	PGPBoolean	operator!=(const WCHAR *wstr) const
	{
		return !Compare(wstr);
	}

	WCHAR	operator[](int pos) const {return mWCharArray[pos];}

	operator UNICODE_STRING&() {return mUniData;}
	operator const UNICODE_STRING&() const {return mUniData;}

	UNICODE_STRING *		Get() {return &mUniData;}
	const UNICODE_STRING *	Get() const {return &mUniData;}

	WCHAR	GetAt(PGPUInt32 pos) const {return mWCharArray[pos];}
	void	SetAt(PGPUInt32 pos, WCHAR wc) {mWCharArray[pos] = wc;}

	WCHAR		LastWChar() const {return GetAt(Length() - 1);}
	PGPBoolean	IsEmpty() const;
	PGPUInt32	Length() const {return (mUniData.Length / sizeof(WCHAR));}

	PGPBoolean	Compare(const UNICODE_STRING& ustr) const;
	PGPBoolean	Compare(const WCHAR *wstr) const;

	PGPBoolean	CompareNoCase(const UNICODE_STRING& ustr) const;
	PGPBoolean	CompareNoCase(const WCHAR *wstr) const;

	CComboError	ToAscii(CString& cstr) const;
	CComboError	ZeroTerminate();

	void	RemoveZeroTermination();
	void	Empty();

	CComboError	Assign(const UNICODE_STRING& ustr);	
	CComboError	Assign(const WCHAR *wstr);
	CComboError	Assign(const char *str);
	CComboError	Assign(char c);

	CComboError	Append(const UNICODE_STRING& ustr);
	CComboError	Append(const WCHAR *wstr);
	CComboError	Append(const char *str);
	CComboError	Append(char c);

	CComboError	Prepend(const UNICODE_STRING& ustr);
	CComboError	Prepend(const WCHAR *wstr);
	CComboError	Prepend(const char *str);
	CComboError	Prepend(char c);

	CComboError	Resize(PGPUInt32 newSize);

protected:
	UNICODE_STRING	mUniData;			// unicode string data
	CArray<WCHAR>	mWCharArray;		// wchar data
	
	void	Init();
};

_PGP_END

#endif	// ] Included_CUnicodeString_h
